{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Tel.: +0351-8012255                   =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 24.02.98 - 23:00:33 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MMUtils, MMHTimer, StdCtrls, MMPCX, MMCCon, MMPCXCtl, MMPCXTol, MMObj,
  MMHook, MMDesign, MMDIBCv, MMLevel;
  
type
  TMainForm = class(TForm)
    MMDesigner1: TMMDesigner;
    Level1: TMMLevel;
    Level2: TMMLevel;
    btnPlay: TButton;
    btnStop: TButton;
    btnFile: TButton;
    Label1: TLabel;
    PlayListBox: TListBox;
    OpenDialog: TOpenDialog;
    PCXConnector: TMMPCXConnector;
    PCXPipe: TMMPCXPipe;
    OutputStream: TMMPCXOutputStream;
    PCXCard: TMMPCXCard;
    MMPCXStreamTimeLabel1: TMMPCXStreamTimeLabel;
    Label2: TLabel;
    MMPCXPipeTimeLabel1: TMMPCXPipeTimeLabel;
    procedure btnPlayClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure btnFileClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure OutputStreamNotify(Sender: TObject; Reason: TMMPCXNotify);
  public
    PlayIndex: integer;
    Stopping: Boolean;
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}


{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FormCreate(Sender: TObject);
begin
   { allocate the Pipe }
   PCXPipe.Allocate;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   btnStopClick(nil);
   { release the Pipe }
   PCXpipe.Release;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnPlayClick(Sender: TObject);
begin
   Stopping  := False;

   PlayIndex := 0;
   PlayListBox.ItemIndex := PlayIndex;

   { prepare the first file }
   OutputStream.FileName := PlayListBox.Items[PlayIndex];
   OutputStream.Prepare(0,PLAY_ALL_FILE);

   { start the stream }
   OutputStream.Play;

   { and now the pipe, playing starts immediately }
   PCXPipe.Start;

   btnStop.Enabled:= True;
   btnPlay.Enabled:= False;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnStopClick(Sender: TObject);
begin
   btnStop.Enabled:= False;
   btnPlay.Enabled:= True;

   { stop playback }
   PCXPipe.Stop;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnFileClick(Sender: TObject);
begin
   { add a file to the playlist }
   if OpenDialog.Execute then
   begin
      PlayListBox.Items.Add(OpenDialog.FileName);
      btnPlay.Enabled := True;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.OutputStreamNotify(Sender: TObject; Reason: TMMPCXNotify);
begin
   case Reason of
       nBeforeEndStream: begin
                            { the stream requires the next file... }

                            { go to the next file }
                            inc(PlayIndex);

                            if not Stopping and (PlayIndex < PlayListBox.Items.Count) then
                            begin
                               { set the next file }
                               OutputStream.FileName := PlayListBox.Items[PlayIndex];
                               OutputStream.Prepare(0,PLAY_ALL_FILE);

                               { update the ListBox }
                               PlayListBox.ItemIndex := PlayIndex;
                            end
                            else
                            begin
                               { stop playback after the current file is done }
                               Stopping := True;
                            end;
                         end;
       nBeginFile      : begin
                            { file is opened }
                         end;
       nCloseFile      : begin
                            { file was read completely and is closed now }
                         end;
       nEndFile        : begin
                            { playback is done at this file }
                            if Stopping then btnStopClick(nil);
                         end;

   end;
end;

end.
